/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jei;

import com.google.common.base.Function;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.tom.storagemod.gui.ContainerCraftingTerminal;
import com.tom.storagemod.jei.IJEIAutoFillTerminal;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class CraftingTerminalTransferHandler
implements IRecipeTransferHandler {
    private final Class<? extends Container> containerClass;
    private static final List<Class<? extends Container>> containerClasses = new ArrayList<Class<? extends Container>>();
    private static final Function<IRecipeLayout, ItemStack[][]> transferFunc = new Function<IRecipeLayout, ItemStack[][]>(){

        public ItemStack[][] apply(IRecipeLayout t) {
            ArrayList<ItemStack[]> inputs = new ArrayList<ItemStack[]>();
            IGuiItemStackGroup itemStackGroup = t.getItemStacks();
            for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
                if (!ingredient.isInput()) continue;
                if (!ingredient.getAllIngredients().isEmpty() && ingredient.getAllIngredients().get(0) != null) {
                    inputs.add(ingredient.getAllIngredients().toArray(new ItemStack[0]));
                    continue;
                }
                inputs.add(null);
            }
            return (ItemStack[][])inputs.toArray((T[])new ItemStack[0][]);
        }
    };
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }

        public void showError(MatrixStack matrixStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        }
    };

    public CraftingTerminalTransferHandler(Class<? extends Container> containerClass) {
        this.containerClass = containerClass;
    }

    public Class<? extends Container> getContainerClass() {
        return this.containerClass;
    }

    public IRecipeTransferError transferRecipe(Container container, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IJEIAutoFillTerminal) {
            if (doTransfer) {
                ItemStack[][] stacks = (ItemStack[][])transferFunc.apply((Object)recipeLayout);
                CompoundNBT compound = new CompoundNBT();
                ListNBT list = new ListNBT();
                for (int i = 0; i < stacks.length; ++i) {
                    if (stacks[i] == null) continue;
                    CompoundNBT CompoundNBT2 = new CompoundNBT();
                    CompoundNBT2.func_74774_a("s", (byte)i);
                    for (int j = 0; j < stacks[i].length && j < 3; ++j) {
                        if (stacks[i][j] == null || stacks[i][j].func_190926_b()) continue;
                        CompoundNBT tag = new CompoundNBT();
                        stacks[i][j].func_77955_b(tag);
                        CompoundNBT2.func_218657_a("i" + j, (INBT)tag);
                    }
                    CompoundNBT2.func_74774_a("l", (byte)Math.min(3, stacks[i].length));
                    list.add((Object)CompoundNBT2);
                }
                compound.func_218657_a("i", (INBT)list);
                ((IJEIAutoFillTerminal)container).sendMessage(compound);
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        for (int i = 0; i < containerClasses.size(); ++i) {
            recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTerminalTransferHandler(containerClasses.get(i)), VanillaRecipeCategoryUid.CRAFTING);
        }
    }

    static {
        containerClasses.add(ContainerCraftingTerminal.class);
    }
}

